import { SlashCommandBuilder } from 'discord.js';
import axios                   from 'axios';

let prompting     = false;
const num_gpu_map = {
  'gemma3:12b': 48,
  'gemma3:27b': 30,
  'dolphin-mixtral:8x7b-v2.5': 9,
  'phi4': 33
};

export default {
  data: new SlashCommandBuilder()
    .setName('prompt')
    .setDescription('Prompt a model')
    .addStringOption(option =>
      option.setName('model')
        .setDescription('The model to prompt, see /models for available models')
        .setRequired(true)
        .addChoices([
          { name: 'gemma3:12b',      value: 'gemma3:12b' },
          { name: 'gemma3:27b',      value: 'gemma3:27b' },
          { name: 'dolphin-mixtral', value: 'dolphin-mixtral:8x7b-v2.5' },
          { name: 'phi4',            value: 'phi4' }
        ])
    )
    .addStringOption(option =>
      option.setName('prompt')
        .setDescription('The prompt to send to the model')
        .setRequired(true)
        .setMaxLength(1500)
    ),

    async execute(interaction) {
      interaction.deferReply();

      if(!prompting) {
        prompting = true;

        const ollamaReply = await axios.post('http://localhost:11434/api/generate', {
          model:  interaction.options.getString('model'),
          prompt: interaction.options.getString('prompt'),
          system: "Feel free to reply with long responses if necessary, but not longer than 2000 characters.",
          stream: false,
          options: {
            num_gpu: num_gpu_map[interaction.options.getString('model')]
          }
        });

        console.log('[INFO] Prompted model:', interaction.options.getString('model'));
        console.log('[INFO] Prompt:', interaction.options.getString('prompt'));

        if(ollamaReply) {
          await interaction.editReply(ollamaReply.data.response);
        }
        else{
          return await interaction.editReply('Unable to prompt ollama, try again later.');
        }

        prompting = false;
      }
      else{
        await interaction.editReply(`Don't make me shit myself, i am already replying to a prompt.`);
      }
    }
};